﻿using System;
using System.Runtime.InteropServices;
using System.Windows.Forms;

namespace PWS.API.Window.Sample5
{
    public partial class FormMain : Form
    {
        [DllImport("user32.dll")]
        public static extern IntPtr FindWindow(string lpClassName, string lpWindowName);

        [DllImport("user32.dll")]
        public static extern IntPtr GetParent(IntPtr hWnd);

        [DllImport("user32.dll")]
        public static extern IntPtr SetParent(IntPtr hWndChild, IntPtr hWndNewParent);

        public FormMain()
        {
            InitializeComponent();
        }

        private void buttonChangeParent_Click(object sender, EventArgs e)
        {
            IntPtr hWndNotepad = FindWindow("Notepad", null);
            if (hWndNotepad != IntPtr.Zero)
            {
                IntPtr hWndOldParent = GetParent(buttonChangeParent.Handle);
                if (hWndOldParent == this.Handle)
                    SetParent(buttonChangeParent.Handle, hWndNotepad);
                else
                    SetParent(buttonChangeParent.Handle, this.Handle);
            }
        }
    }
}